<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class Link extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "link";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[link=\"http://www.google.com\"]Google[/link]\n[link url=\"http://www.google.com\" target=\"_blank\"]Google[/link]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = array(
		array(
			"name"		=> "url",
			"hint"		=> "url of the link"
		),
		
		array(
			"name"		=> "target",
			"hint"		=> "_blank, default: none"
		),

		array(
			"name"		=> "rel",
			"hint"		=> "nofolow|noindex|follow|index, default: none",			
		),

		array(
			"name"		=> "color",
			"hint"		=> "#hexcode, default: skin color",			
		),
		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization",			
		),
	);
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {

		$this->loadTemplate();

		$vars	= $data["vars"];
		$css	= array();
		$style	= array();
		$attr	= array();

		if ($vars["color"]) {
			$style[] = $this->getBackground($vars["color"] , "color")["bg_style"];
		}

		$info = array(
			"url"		=> $vars["url"],
			"target"	=> $vars["target"],
			"rel"		=> $vars["rel"],
			"css"		=> $vars["class"],
			"content"	=> $vars["content"],
			"style"	=> implode(" " , $style),
		);
		
		return array(
			"content"	=> $this->tpl->blockReplace(
				"Main" , 
				$info
			),
			"before"	=> "",
			"after"		=> "",
		);

	}
	
}